<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
<?xml version="1.0" encoding="UTF-8"?>
<configuration debug="false">
<springProperty scope="context" name="systemname" source="ibiz.systemname" />
<property name="LOG_PATH" value="logs" />
<!--MDC自定义内容添加。-->
<!--<property name="LOG_PATTERN" value="%d{yyyy-MM-dd HH:mm:ss.SSS}  [%t] [%-5level] %-40.40logger{39} [%m][%X{mdc_trace_id}]: %msg%n" />-->
<property name="LOG_PATTERN" value="%d{yyyy-MM-dd HH:mm:ss.SSS}  [%t] [%-5level] %-40.40logger{39} [%method]: %msg%n" />
<!--<property name="LOG_PATTERN" value="%d{yyyy-MM-dd HH:mm:ss.SSS}  [%t] [%-5level] %-40.40logger{39} : %msg%n" />-->
<!-- 彩色日志 -->
<!-- 彩色日志依赖的渲染类 -->
<conversionRule conversionWord="clr" converterClass="org.springframework.boot.logging.logback.ColorConverter" />
<conversionRule conversionWord="wex" converterClass="org.springframework.boot.logging.logback.WhitespaceThrowableProxyConverter" />
<conversionRule conversionWord="wEx" converterClass="org.springframework.boot.logging.logback.ExtendedWhitespaceThrowableProxyConverter" />
<!-- 彩色日志格式 -->
<property name="LOG_PATTERN2" value="${r'${CONSOLE_LOG_PATTERN:-%clr(%d{yyyy-MM-dd HH:mm:ss.SSS}){faint} %clr([${LOG_LEVEL_PATTERN:-%5p}]) %clr(%-40.40logger{39}){cyan} %clr(:){faint} %m%n${LOG_EXCEPTION_CONVERSION_WORD:-%wEx}}'}" />

<!-- 控制台输出 -->
<appender name="console" class="ch.qos.logback.core.ConsoleAppender">
    <encoder class="ch.qos.logback.classic.encoder.PatternLayoutEncoder">
        <pattern>${r'${LOG_PATTERN}'}</pattern>
    </encoder>
</appender>

<!-- 按照每天生成日志文件 -->
<appender name="file"  class="ch.qos.logback.core.rolling.RollingFileAppender">
    <rollingPolicy class="ch.qos.logback.core.rolling.TimeBasedRollingPolicy">
        <!--日志文件输出的文件名-->
        <FileNamePattern>${r'${LOG_PATH}'}/${sys.getCodeName()?lower_case}.%d{yyyy-MM-dd}.log</FileNamePattern>
        <!--日志文件保留天数-->
        <MaxHistory>30</MaxHistory>
    </rollingPolicy>
    <encoder class="ch.qos.logback.classic.encoder.PatternLayoutEncoder">
        <pattern>${r'${LOG_PATTERN}'}</pattern>
    </encoder>

    <!--日志文件最大的大小-->
    <triggeringPolicy class="ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy">
        <MaxFileSize>100MB</MaxFileSize>
    </triggeringPolicy>
</appender>

<!--logstash远程日志添加-->
<appender name="logstash" class="net.logstash.logback.appender.LogstashTcpSocketAppender">
    <!--logstash server所在位置-->
    <destination>127.0.0.1:5044</destination>
    <encoder class="net.logstash.logback.encoder.LogstashEncoder">
        <providers>
            <timestamp>
                <timeZone>CST</timeZone>
            </timestamp>
        </providers>
    </encoder>
</appender>
<!-- 日志输出级别 -->
<root level="INFO">
    <appender-ref ref="console" />
    <appender-ref ref="file" />
    <#if ((pub.getUserTag4())!'')=='nancy'>
    <appender-ref ref="logstash" />
    </#if>
</root>
</configuration>
